
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<html>
<head>
    <meta name="description" content="Vali is a responsive and free admin theme built with Bootstrap 4, SASS and PUG.js. It's fully customizable and modular.">
    <!-- Twitter meta-->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:site" content="@pratikborsadiya">
    <meta property="twitter:creator" content="@pratikborsadiya">
    <!-- Open Graph Meta-->
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="Vali Admin">
    <meta property="og:title" content="Vali - Free Bootstrap 4 admin theme">
    <meta property="og:url" content="http://pratikborsadiya.in/blog/vali-admin">
    <meta property="og:image" content="http://pratikborsadiya.in/blog/vali-admin/hero-social.png">
    <meta property="og:description" content="Vali is a responsive and free admin theme built with Bootstrap 4, SASS and PUG.js. It's fully customizable and modular.">
    <title>Data Table - Vali Admin</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Main CSS-->
    <link rel="stylesheet" type="text/css" href="/static/css/main.css">
    <!-- Font-icon css-->
    <link rel="stylesheet" type="text/css" href="/static/css/font-awesome.min.css">
</head>
<body class="app sidebar-mini"  style="padding:0px; background:url(http://localhost:8080/static/images/bj.jpg); background-size:100%;">
<style>

    .app-header {
        position: fixed;
        left: 0;
        right: 0;
        top: 0;
        width: 100%;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        background-color: #e83e8c;
        z-index: 1030;
        padding-right: 15px;
    }
    .btn-primary {
        color: #FFF;
        background-color: #e83e8c;
        border-color: #e83e8c;
    }
    .btn-primary {
        color: #FFF;
        background-color: #e83e8c;
        border-color: #e83e8c;
    }

    .btn-primary:hover {
        color: #FFF;
        background-color: #e83e8c;
        border-color: #e83e8c;
    }

    .btn-outline-primary:not(:disabled):not(.disabled):active:focus, .btn-outline-primary:not(:disabled):not(.disabled).active:focus,
    .show > .btn-outline-primary.dropdown-toggle:focus {
        -webkit-box-shadow: 0 0 0 0 rgb(232 62 140);
        box-shadow: 0 0 0 0 rgb(232 62 140);
    }

    .btn-primary:focus, .btn-primary.focus {
        -webkit-box-shadow: 0 0 0 0 #e83e8c;
        box-shadow: 0 0 0 0 #e83e8c;
    }
    .btn-primary.disabled, .btn-primary:disabled {
        color: #FFF;
        background-color: #e83e8c;
        border-color: #e83e8c;
    }
    a {
        color: #d841b4;
    }
</style>

<!-- Navbar-->
<header class="app-header">
    <ul class="app-nav">
        <li class="app-search">
            <input class="app-search__input" type="search" placeholder="搜索">
            <button class="app-search__button"><i class="fa fa-search"></i></button>
        </li>

        <!-- User Menu-->
        <li class="dropdown"><a class="app-nav__item" href="#" data-toggle="dropdown" aria-label="Open Profile Menu"><i class="fa fa-user fa-lg"></i></a>
            <ul class="dropdown-menu settings-menu dropdown-menu-right">
                <li><a class="dropdown-item" href="http://localhost:8080/findOrderByName?name=${order.name}"><i class="fa fa-sign-out fa-lg"></i> 借书记录</a></li>
                <li><a class="dropdown-item" href="http://localhost:8080/allBook2"><i class="fa fa-sign-out fa-lg"></i>  退出 </a></li>
            </ul>
        </li>
    </ul>
</header>

    <div class="row" style="padding-top: 70px;padding-right: 20px;padding-left: 20px;margin-left: 0px;margin-right: 0px;">
        <h3 align="center">目前以下书籍正在热销</h3>
        <h3>${msg}</h3>
    </div>

    <div class="row" style="padding-top: 70px;padding-right: 20px;padding-left: 20px;margin-left: 0px;margin-right: 0px;">



        <c:forEach items="${orders}" var="order">
            <div class="col-md-4">
                <div class="tile">
                    <div class="tile-title-w-btn">
                        <h3 class="title">${order.bookname}</h3>
                        <p><a class="btn btn-primary icon-btn" href="http://localhost:8080/deleteOrder1?id=${order.id}&name=${order.name}"><i class="fa fa-plus"></i>还书</a></p>
                    </div>
                    <div class="tile-body">
                        <b>价格：${order.bookprice}</b>
                    </div>
                </div>
            </div>
        </c:forEach>


    </div>

<!-- Essential javascripts for application to work-->
<script src="/static/js/jquery-3.3.1.min.js"></script>
<script src="/static/js/popper.min.js"></script>
<script src="/static/js/bootstrap.min.js"></script>
<script src="/static/js/main.js"></script>
<!-- The javascript plugin to display page loading on top-->
<script src="/static/js/plugins/pace.min.js"></script>
<!-- Page specific javascripts-->
<!-- Data table plugin-->
<script type="text/javascript" src="/static/js/plugins/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="/static/js/plugins/dataTables.bootstrap.min.js"></script>
<script type="text/javascript">$('#sampleTable').DataTable();</script>
<!-- Google analytics script-->
<script type="text/javascript">
    if(document.location.hostname == 'pratikborsadiya.in') {
        (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
            (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
            m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
        })(window,document,'script','//www.google-analytics.com/analytics.js','ga');
        ga('create', 'UA-72504830-1', 'auto');
        ga('send', 'pageview');
    }
</script>
</body>
</html>
