package com.ssm.controller;

import com.ssm.domain.User;
import com.ssm.service.Impl.UserServletImpl;
import com.ssm.service.UserServlet;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import java.util.List;

@Controller
public class UserController {
    @Resource
    UserServlet userServlet;

    // 退出
    @RequestMapping("/logout")
    public String logout(Model model, User user){
        model.addAttribute("msg","您已经退出");
        return "index.jsp";
    }

    // 登录
    @RequestMapping("/loginUser")
    public String loginUser(Model model, User user){
        User loginUserOne = userServlet.loginUser(user);
        if (loginUserOne != null){
            if (loginUserOne.getMyid().equals(1)){
                model.addAttribute("loginUserOne",loginUserOne);
                return "forward:/allUser";
            }else {
                model.addAttribute("loginUserOne",loginUserOne);
                return "forward:/allBook2";
            }
        }else {
            model.addAttribute("msg","用户名或密码错误");
            return "index.jsp";
        }
    }

    // 查询全部User
    @RequestMapping("/allUser")
    public String allUser(Model model){
        List<User> users = userServlet.allUser();
        model.addAttribute("users",users);
        return "pages/table-user.jsp";
    }

    // 修改User
    @RequestMapping("/jumpUpdateUser")
    public String jumpUpdateUser(Model model,User user){
        return "forward:/pages/update/update-user.jsp";
    }
    @RequestMapping("/updateUser")
    public String updateUser(Model model,User user){
        Integer integer = userServlet.updateUser(user);
        if (integer > 1){
            model.addAttribute("msg","成功");
        }else {
            model.addAttribute("msg","失败");
        }
        return "forward:/allUser";
    }

    // 删除User
    @RequestMapping("/deleteUser")
    public String deleteUser(Model model,Integer id){
        Integer integer = userServlet.deleteUser(id);
        if (integer > 1){
            model.addAttribute("msg","成功");
        }else {
            model.addAttribute("msg","失败");
        }
        return "forward:/allUser";
    }

    // 添加User
    @RequestMapping("/jumpInsertUser")
    public String jumpInsertUser(Model model,User user){
        return "forward:/pages/insert/insert-user.jsp";
    }
    @RequestMapping("/insertUser")
    public String insertUser(Model model,User user){
        Integer integer = userServlet.insertUser(user);
        if (integer > 1){
            model.addAttribute("msg","成功");
        }else {
            model.addAttribute("msg","失败");
        }
        return "forward:/allUser";
    }
}
