package com.ssm.controller;

import com.ssm.domain.Book;
import com.ssm.domain.Order;
import com.ssm.domain.User;
import com.ssm.service.OrderServlet;
import com.ssm.service.UserServlet;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Controller
public class OrderController {

    @Resource
    OrderServlet orderServlet;
    @Resource
    UserServlet userServlet;

    // 查询全部order
    @RequestMapping("/allOrder")
    public String allOrder(Model model){
        List<Order> orders = orderServlet.allOrder();
        model.addAttribute("orders",orders);
        return "pages/table-order.jsp";
    }

    // 修改Order
    @RequestMapping("/jumpUpdateOrder")
    public String jumpUpdateOrder(Model model, Order order){
        return "forward:/pages/update/update-order.jsp";
    }
    @RequestMapping("/updateOrder")
    public String updateOrder(Model model,Order order){
        Integer integer = orderServlet.updateOrder(order);
        if (integer > 1){
            model.addAttribute("msg","成功");
        }else {
            model.addAttribute("msg","失败");
        }
        return "forward:/allOrder";
    }

    // 删除Order
    @RequestMapping("/deleteOrder")
    public String deleteUser(Model model,Integer id){
        Integer integer = orderServlet.deleteOrder(id);
        if (integer > 1){
            model.addAttribute("msg","成功");
        }else {
            model.addAttribute("msg","失败");
        }
        return "forward:/allOrder";
    }

    //还书
    @RequestMapping("/deleteOrder1")
    public String deleteOrder(Model model,String name,Integer id){
        Integer integer = orderServlet.deleteOrder(id);
        System.out.println(integer);
        if (integer != 0){
            model.addAttribute("msg","归还成功！");
            System.out.println(name);
            model.addAttribute("name",name);
            return "forward:/findOrderByName";
        }else {
            model.addAttribute("msg","归还失败！");
        }
        return "pages/home-order.jsp";
    }

    // 添加Book
    @RequestMapping("/jumpInsertOrder")
    public String jumpInsertOrder(Model model,Order order){
        return "forward:/pages/insert/insert-order.jsp";
    }
    @RequestMapping("/insertOrder")
    public String insertOrder(Model model,Order order){
        Integer integer = orderServlet.insertOrder(order);
        if (integer > 1){
            model.addAttribute("msg","成功");
        }else {
            model.addAttribute("msg","失败");
        }
        return "forward:/allOrder";
    }
    @RequestMapping("/insertOrder2")
    public String insertOrder2(HttpServletRequest request,Model model, Order order){
        Integer integer = orderServlet.insertOrder(order);
        if (integer != 0){
            model.addAttribute("msg","借阅成功！");
        }else {
            model.addAttribute("msg","借阅失败！");
        }
        User user1 = new User();
        user1.setName(order.getName());
        user1.setPwd(request.getParameter("pwd"));
        User user = userServlet.loginUser(user1);
        model.addAttribute("loginUserOne",user);
        return "forward:/allBook2";
    }

    // 客户查询全部order
    @RequestMapping("/findOrderByName")
    public String findOrderByName(Model model,String name){
        List<Order> orders = orderServlet.findOrderByName(name);
        model.addAttribute("orders",orders);
        return "pages/home-order.jsp";
    }
     //
     @RequestMapping("/NameOrder")
     public String NameOrder(Model model,String name){
         List<Order> orders = orderServlet.NameOrder(name);
         model.addAttribute("orders",orders);
         return "pages/table-order.jsp";
     }
}
