package com.ssm.controller;

import com.ssm.domain.Book;
import com.ssm.domain.User;
import com.ssm.service.BookServlet;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import java.util.List;

@Controller
public class  BookController {

    @Resource
    BookServlet bookServlet;

    // 查询全部Book
    @RequestMapping("/allBook")
    public String allBook(Model model){
        List<Book> books = bookServlet.allBook();
        model.addAttribute("books",books);
        return "pages/table-book.jsp";
    }
    @RequestMapping("/allBook2")
    public String allBook2(Model model){
        List<Book> books = bookServlet.allBook();
        model.addAttribute("books",books);
        return "pages/home-page.jsp";
    }
    // 用户名模糊查询书籍
    @RequestMapping("/FdBook")
    public String FdBook(Model model,String name){
        List<Book> books = bookServlet.FdBook(name);
        model.addAttribute("books",books);
        return "pages/table-book.jsp";
    }
    // 用户名模糊查询书籍
    @RequestMapping("/FdBook1")
    public String FdBook1(Model model,String name){
        List<Book> books = bookServlet.FdBook(name);
        model.addAttribute("books",books);
        return "pages/table-book.jsp";
    }

    // 修改Book
    @RequestMapping("/jumpUpdateBook")
    public String jumpUpdateBook(Model model, Book book){
        return "forward:/pages/update/update-book.jsp";
    }
    @RequestMapping("/updateBook")
    public String updateBook(Model model,Book book){
        Integer integer = bookServlet.updateBook(book);
        if (integer > 1){
            model.addAttribute("msg","成功");
        }else {
            model.addAttribute("msg","失败");
        }
        return "forward:/allBook";
    }

    // 删除Book
    @RequestMapping("/deleteBook")
    public String deleteBook(Model model,Integer id){
        Integer integer = bookServlet.deleteBook(id);
        if (integer > 1){
            model.addAttribute("msg","成功");
        }else {
            model.addAttribute("msg","失败");
        }
        return "forward:/allBook";
    }


    // 添加Book
    @RequestMapping("/jumpInsertBook")
    public String jumpInsertBook(Model model,Book book){
        return "forward:/pages/insert/insert-book.jsp";
    }
    @RequestMapping("/insertBook")
    public String insertBook(Model model,Book book){
        Integer integer = bookServlet.insertBook(book);
        if (integer > 1){
            model.addAttribute("msg","成功");
        }else {
            model.addAttribute("msg","失败");
        }
        return "forward:/allBook";
    }

}
